//&L(0,"*",1);

/* location configs */
var SE=0;
var TD=1;
var SED=2
var TED=3;

var gObj;
var gHwt=&LState(1,"%u",28);;
var gHmt=&LState(1,"%u",35);;
var gCfg=&LSetup(1,"%u",536,B);;
 
function clear() {
	gObj.getElementById('basic').style.display = "none";
	gObj.getElementById('network').style.display = "none";
	gObj.getElementById('stream_out').style.display = "none";
	gObj.getElementById('stream_out_hdr').style.display="none";
	gObj.getElementById('stream_out_1').style.display="none";
	gObj.getElementById('stream_out_rest').style.display="none";
	gObj.getElementById('stream_keep_alive').style.display="none";
	gObj.getElementById('stream_csync').style.display="none";
	gObj.getElementById('stream_inc').style.display="none";
	gObj.getElementById('stream_rtp_delay').style.display="none";
	gObj.getElementById('stream_output_params').style.display="none";
	gObj.getElementById('audio_hdr').style.display = "none";
	gObj.getElementById('audio_fmt').style.display = "none";
	gObj.getElementById('audio_mp3_br_mode').style.display = "none";
	gObj.getElementById('audio_mp3_br').style.display = "none";
	gObj.getElementById('audio_mp3_bres').style.display = "none";
	gObj.getElementById('audio_sample_rate').style.display = "none";
	gObj.getElementById('audio_quality').style.display = "none";	
	gObj.getElementById('audio_source_gain').style.display = "none";
	gObj.getElementById('audio_mic_gain').style.display = "none";
	gObj.getElementById('audio_output').style.display = "none";
	gObj.getElementById('audio_fading').style.display = "none";
	gObj.getElementById('io').style.display = "none";
	gObj.getElementById('io_r4to8').style.display = "none";
	gObj.getElementById('io_r9').style.display = "none";
	gObj.getElementById('io_alarms').style.display = "none";
	gObj.getElementById('serial').style.display = "none";
	gObj.getElementById('security').style.display = "none";
}
/*
 * IE  6.0 need this compatibility function
 */
function addPortableOption (name,value,def,sel)
{
	var opt = new Option(name,value,def);
	if (sel==value) idsel=idx-1;

	return opt;
}
function loadLocations()
{
	var y=document.getElementById('stype');
	idsel=-1; // value set from addPortableOption
	idx=0;
	switch (gHwt) {
		case 1:
		case 9:
		case 14:
		case 15:
		case 20:
		case 34:
		case 36:
		case 37:
		case 38: // until Ext 205
			y.options[idx++]=addPortableOption("Transmitter Decoder",1,true,gCfg);
		break;
		case 8:
			y.options[idx++]=addPortableOption("Studio Encoder",0,true,gCfg);
		break;
		default:
			y.options[idx++]=addPortableOption("Studio Encoder",0,true,gCfg);
			y.options[idx++]=addPortableOption("Transmitter Decoder",1,false,gCfg);
			y.options[idx++]=addPortableOption("Studio Encoder/Decoder",2,false,gCfg);
			y.options[idx++]=addPortableOption("Transmitter Encoder/Decoder",3,false,gCfg);
		break;
	}
	y.selectedIndex=(idsel==-1) ? 0 : idsel;
}
function def_hideshow(frame){
	if (frame)
		gObj=parent.frames[frame].document;
	else
		gObj=document;
	clear();
	toggleDisplay('1');
	aftChange();
}
function turnBackBold(speclink){
	var anchors=document.links
	for (i=0;i<anchors.length;i++){
		anchors[i].style.fontWeight='300';
	}
	speclink.style.fontWeight='900';
}
function showHideQlty() {
	var i=gObj.getElementById('aft').value;
	if (i>=6) {
		gObj.getElementById('audio_quality').style.display="";
	} else {
		gObj.getElementById('audio_quality').style.display="none";
	}
}
function showHideBR() {
	var i=gObj.getElementById('aft').value;
	if (i>=6) {
		gObj.getElementById('audio_mp3_br_mode').style.display = "";
		var m=gObj.getElementById('brm').value;
		if (m==2) {
			gObj.getElementById('audio_quality').style.display = "none";
			gObj.getElementById('audio_mp3_br').style.display = "";
			gObj.getElementById('audio_mp3_bres').style.display = "";
		}
		else { // 0=VBR
			gObj.getElementById('audio_quality').style.display = "";
			gObj.getElementById('audio_mp3_br').style.display = "none";
			gObj.getElementById('audio_mp3_bres').style.display = "none";
		}
	} else {
		gObj.getElementById('audio_mp3_br_mode').style.display = "none";
		gObj.getElementById('audio_mp3_br').style.display = "none";
		gObj.getElementById('audio_mp3_bres').style.display = "none";
	}
}
function setInputSource()
{
   var t=document.getElementById('isrc');
	idsel=-1;
   idx=0;
   t.options.length=0;
   var sel=&LSetup(1,"%lu",510,B);;
	switch (gHwt) {
	case 43: /* Instreamer 100(ECO) */
	case 8:  /* Instreamer 100 */
		t.options[idx++]=addPortableOption("Line Mono",129,false,sel);
		t.options[idx++]=addPortableOption("Line Stereo",1,false,sel);
		if (gHmt==0) // micronas only
		{
			t.options[idx++]=addPortableOption("SPDIF coaxial",5,false,sel);
   		t.options[idx++]=addPortableOption("SPDIF optical",4,false,sel);
		}
	break;
	case 35: /* Exstreamer 500 */
		t.options[idx++]=addPortableOption("Line Mono",129,false,sel);
		t.options[idx++]=addPortableOption("Line Stereo",1,false,sel);
		if (gHmt==0) // micronas only
			t.options[idx++]=addPortableOption("Line Ext ADC",7,false,sel);
	break;
	case 21: /* Exstreamer 1000 */
		t.options[idx++]=addPortableOption("Line Mono",129,false,sel);
		t.options[idx++]=addPortableOption("Line Stereo",1,false,sel);
		if (gHmt==0) // micronas only
		{
			t.options[idx++]=addPortableOption("AES-EBU",9,false,sel);
			t.options[idx++]=addPortableOption("Line Ext ADC",7,false,sel);
		}
	break;
	case 7:	/* Annuncicom 100 */
	case 19:	/* Annuncicon 200 */
	case 27:	/* Annuncicon 200 Aiphone */
		t.options[idx++]=addPortableOption("Line Mono",129,false,sel);
		t.options[idx++]=addPortableOption("Line Stereo",1,false,sel);
		t.options[idx++]=addPortableOption("MIC",2,false,sel);
	break;
	case 13: /* IPAM 100 */
	case 39: /* IPAM 101 */
	case 40: /* IPAM 102 */
	case 41: /* Annuncicom 50 */
	case 17: /* Annuncicom 1000 */
		t.options[idx++]=addPortableOption("Line Mono",129,false,sel);
		t.options[idx++]=addPortableOption("Line Stereo",1,false,sel);
		t.options[idx++]=addPortableOption("MIC",2,false,sel);
	break;
	case 32: /* Annuncicom 155 */
	case 42: /* Annuncicom PS1 */
		t.options[idx++]=addPortableOption("MIC",2,false,sel);
	break;
	case 33: /* Annuncicom VME, special case */
		t.options[idx++]=addPortableOption("Line Mono",129,false,sel);
		t.options[idx++]=addPortableOption("-- Line Out Stereo --",2,false,sel);
		t.options[idx++]=addPortableOption("Line Stereo",1,false,sel);
	break;
	
	}
	t.selectedIndex=(idsel==-1) ? 0 : idsel;
}
// dynamic sample rate based on Audio Format, i is the AF value
function loadSampleRates()
{
	var i=gObj.getElementById('aft').value;
	var s=gObj.getElementById('srt');
	s.options.length=0;
	var sel=&LSetup(1,"%lu",512,B);;
	idsel=-1;
	idx=0;
	if (i<6) { // Analog
		if (i<4) { // u-law/A-law/PCM
			/* disabling IPAM102 FD 8Khz PCM 16bit mono for bt 053.90 */
			if (!(gHmt==2 && i==2 /* PCM 16bit mono */ && gCfg>=2 /* FD */)) {
				s.options[idx++]=addPortableOption("8 kHz",0,false,sel);
			}
			s.options[idx++]=addPortableOption("24 kHz",4,false,sel); // all analog mono
		}
		//if (i <4)	{ srtdd.options[n++]=addPortableOption("12 kHz",1,false,sel); }	// DISABLE
		if (i==4) {
			if (gCfg>=2) {
				s.options[idx++]=addPortableOption("16 kHz",2,false,sel);
				s.options[idx++]=addPortableOption("32 kHz",5,false,sel);
			}  // 16/32 Khz PCM only FD, non std payloads
			if (gHmt==0) // 44.1 allowed only on legacy IPAM100
				s.options[idx++]=addPortableOption("44.1 kHz",6,false,sel);   // 44.1 Khz stereo big endian only
			s.options[idx++]=addPortableOption("48 kHz",7,false,sel);   // 48 Khz PCM, stereo big endian only
		}
	} else { // MPEG
		s.options[idx++]=addPortableOption("16 kHz (MPEG2 Layer III)",2,false,sel);
		s.options[idx++]=addPortableOption("22.05 kHz (MPEG2 Layer III)",3,false,sel);
		s.options[idx++]=addPortableOption("24 kHz (MPEG2 Layer III)",4,false,sel);
		s.options[idx++]=addPortableOption("32 kHz (MP3)",5,false,sel);
		s.options[idx++]=addPortableOption("44.1 kHz (MP3)",6,false,sel);
		s.options[idx++]=addPortableOption("48 kHz (MP3)",7,false,sel);
	}
	s.selectedIndex=(idsel==-1) ? 0 : idsel;
}

function show_section_basic ()
{
	gObj.getElementById('basic').style.display="";
	if (gCfg!=TD) {
		gObj.getElementById('stream_out').style.display="";
		gObj.getElementById('stream_out_hdr').style.display="";
		gObj.getElementById('stream_out_1').style.display="";
	}
	if (gCfg!=SE) {
		gObj.getElementById('stream_inc').style.display="";
	}
}
function show_section_network ()
{
	gObj.getElementById('network').style.display="";
}
function show_section_streaming ()
{
   gObj.getElementById('stream_out').style.display="";
	if (gCfg!=TD) {
		gObj.getElementById('stream_out_hdr').style.display="";
		gObj.getElementById('stream_out_1').style.display="";
		gObj.getElementById('stream_out_rest').style.display="";
	}
	gObj.getElementById('stream_keep_alive').style.display="";
	if (gCfg!=SE) {
		gObj.getElementById('stream_inc').style.display="";
		gObj.getElementById('stream_rtp_delay').style.display="";
		gObj.getElementById('stream_csync').style.display="";
		gObj.getElementById('stream_output_params').style.display="";
	}
}
function show_section_audio ()
{
	gObj.getElementById('audio_hdr').style.display="";
	if (gCfg!=TD)
	{
		gObj.getElementById('audio_fmt').style.display="";
		gObj.getElementById('audio_sample_rate').style.display="";
		if(gCfg==SE) {
			showHideQlty();
			showHideBR();
		}
		gObj.getElementById('audio_source_gain').style.display="";	
		if(gHwt==7||gHwt==19||gHwt==17||gHwt==32)
			gObj.getElementById('audio_mic_gain').style.display="";
	}
	gObj.getElementById('audio_output').style.display="";
	if(gCfg!=SE) gObj.getElementById('audio_fading').style.display="";
}
function show_section_io ()
{
	var txt=(gHwt==17||gHwt==33)?"":"none";
	gObj.getElementById('io').style.display="";	
	gObj.getElementById('io_r4to8').style.display=txt;
	if (gHwt==17) txt=""; else txt="none";
	gObj.getElementById('io_r9').style.display=txt;
	gObj.getElementById('io_alarms').style.display="";
}
function show_section_serial ()
{
	gObj.getElementById('serial').style.display="";
}
function show_section_security ()
{
	gObj.getElementById('security').style.display="";
}

function toggleDisplay(e) {
	// called from left menu, gObj must be set relative to that frame
	gObj=parent.frames['config'].document;
	/* cfg values, SE 0, TD 1, SED 2, TED 3 */
	clear();
	switch (e) {
		default:
		case '1': show_section_basic(); break;
		case '2': show_section_network(); break;
		case '3': show_section_streaming(); break;
		case '4': show_section_audio(); break;
		case '5': show_section_io(); break;
		case '6': show_section_serial(); break;
		case '7': show_section_security(); break;
	}
}

function aftChange(show) {
	if(show) {
		showHideQlty();
		showHideBR();
	}
	loadSampleRates();
}
// dynamic Audio Format options, inserting as per site type (st)
function selAudioFormat(){
	var a=document.getElementById("aft");
	a.options.length=0;
	var sel=&LSetup(1,"%u",511,B);;
	idsel=-1;
	idx=0;
	if (gCfg!=1) {
		// analog
		a.options[idx++]=addPortableOption("\xb5-law 8bit mono", 0, false, sel);
		a.options[idx++]=addPortableOption("A-law 8bit mono ", 1, false, sel);
		a.options[idx++]=addPortableOption("PCM 16bit mono MSB", 2, false, sel);
		//a.options[3]=addPortableOption("PCM 16bit mono little endian", 3, false, sel);
		a.options[idx++]=addPortableOption("PCM 16bit stereo MSB", 4, false, sel);
		//a.options[5]=addPortableOption("PCM 16bit stereo little endian", 5, false, sel);
	}
	if (gCfg==0)
	{
		if (gHmt!=1) // non IPAM101 only
		{
			a.options[idx++]=addPortableOption("MPEG mono", 6, false, sel);
			a.options[idx++]=addPortableOption("MPEG stereo", 7, false, sel);
		}
	}
	a.selectedIndex=(idsel==-1) ? 0 : idsel;
}

function select_id(obj,val)
{
	var i=0;
	for(i=0;i<obj.length;++i){
		if (val==obj.options[i].value) {
			obj.selectedIndex=i;
			return;	
		}
	}
	obj.selectedIndex=0;
}

function sel(id,val)
{
	select_id(document.getElementById(id),val);
}

